/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.block;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.BlockPropertyChangeEvent;
import DE.siemens.ad.logo.model.CamParameter;
import DE.siemens.ad.logo.model.ClockParameter;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareChangedEvent;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.ParameterInBlockConnector;
import DE.siemens.ad.logo.model.SpecialBlock;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.util.Logger.ErrorInfo;
import java.io.IOException;
import java.util.List;

public class ClockBlock
extends SpecialBlock {
    static final long serialVersionUID = 540495048091475226L;
    private int clockBlockSerializedDataVersion = 1;
    ClockParameter fClockParameter;

    public ClockBlock() {
    }

    public ClockBlock(WiringDiagram wiringDiagram) {
        super(wiringDiagram);
    }

    protected boolean calculateBinaryValue() {
        return ((ClockParameter)this.getParameter()).getValue();
    }

    protected int getDefaultOrder() {
        return 900;
    }

    public BlockParameter getParameter() {
        return this.fClockParameter;
    }

    protected void initInConnectors() {
        this.fInConnectors = new InBlockConnector[3];
        String name = "DE.siemens.ad.logo.model.ClockParameter";
        this.fInConnectors[0] = new ParameterInBlockConnector((Block)this, name, "");
        this.fClockParameter = (ClockParameter)((ParameterInBlockConnector)this.fInConnectors[0]).getLinkedParameter();
        this.fInConnectors[0] = new ParameterInBlockConnector((Block)this, this.fClockParameter.getCam(0), "No 1");
        this.fInConnectors[1] = new ParameterInBlockConnector((Block)this, this.fClockParameter.getCam(1), "No 2");
        this.fInConnectors[2] = new ParameterInBlockConnector((Block)this, this.fClockParameter.getCam(2), "No 3");
    }

    public boolean isAvailable(Hardware hw, List errorList) {
        boolean result = super.isAvailable(hw, errorList);
        if (this.isInnovation2Clock() && !hw.supports("anyDayClock")) {
            errorList.add(new ErrorInfo(this, "error.convert.anyDayClock", hw));
            result &= false;
        }
        if (this.isDifferentProtection() && hw.supports("clockOneProtection")) {
            errorList.add(new ErrorInfo(this, "error.convert.oneProtectionClock", hw));
            result &= false;
        }
        if (this.fClockParameter.getPulse().booleanValue() && !hw.supports("pulseClock")) {
            errorList.add(new ErrorInfo(this, "error.convert.pulseClock", hw));
            result &= false;
        }
        return result;
    }

    public void hardwareChanged(HardwareChangedEvent hardwareChangedEvent) {
        Hardware oldHardware = (Hardware)hardwareChangedEvent.getOldValue();
        Hardware newHardware = (Hardware)hardwareChangedEvent.getNewValue();
        boolean changeParameter = true;
        boolean oldOneProtection = false;
        boolean newOneProtection = false;
        if (oldHardware != null) {
            oldOneProtection = oldHardware.supports("clockOneProtection");
            boolean bl = changeParameter = oldOneProtection != (newOneProtection = newHardware.supports("clockOneProtection"));
        }
        if (changeParameter) {
            ClockParameter param = (ClockParameter)this.getParameter();
            if (newOneProtection) {
                boolean commonProtection = this.getCommonProtection();
                param.setProtection(commonProtection);
                this.setCommonProtection(commonProtection);
            } else {
                boolean protection = param.getProtection();
                int camCount = param.getCamCount();
                for (int i = 0; i < camCount; ++i) {
                    param.getCam(i).setProtection(protection);
                }
            }
            this.fireBlockPropertyChangeEvent(new BlockPropertyChangeEvent(this, "param;"));
        }
        this.setHardware(newHardware);
    }

    public boolean getCommonProtection() {
        boolean protection = false;
        ClockParameter clockParameter = (ClockParameter)this.getParameter();
        int count = clockParameter.getCamCount();
        for (int i = 0; i < count; ++i) {
            CamParameter cam = clockParameter.getCam(i);
            if (cam.getOnTime().isInactive() && cam.getOffTime().isInactive()) continue;
            protection = cam.getProtection();
            break;
        }
        return protection;
    }

    private boolean isDifferentProtection() {
        ClockParameter clockParameter = (ClockParameter)this.getParameter();
        Boolean protection = null;
        int count = clockParameter.getCamCount();
        for (int i = 0; i < count; ++i) {
            CamParameter cam = clockParameter.getCam(i);
            if (cam.getOnTime().isInactive() && cam.getOffTime().isInactive()) continue;
            if (protection == null) {
                protection = new Boolean(cam.getProtection());
                continue;
            }
            if (protection.booleanValue() == cam.getProtection()) continue;
            return true;
        }
        return false;
    }

    public boolean isInnovation2Clock() {
        ClockParameter clockParameter = (ClockParameter)this.getParameter();
        for (int i = 0; i < clockParameter.getCamCount(); ++i) {
            CamParameter camPara = clockParameter.getCam(i);
            if (camPara.getOnTime().isInactive() && camPara.getOffTime().isInactive() || camPara.getAvailableModes()[camPara.getMode()].isPredefinedMode()) continue;
            return true;
        }
        return false;
    }

    public boolean isLeftTerminal() {
        return true;
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fClockParameter = (ClockParameter)dr.readStorable();
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(this.fClockParameter);
    }

    private void setCommonProtection(boolean protection) {
        ClockParameter clockParameter = (ClockParameter)this.getParameter();
        int count = clockParameter.getCamCount();
        for (int i = 0; i < count; ++i) {
            clockParameter.getCam(i).setProtection(protection);
        }
    }
}

